		INCLUDE	"00labels.lst"		;Get labels
		org	49152

;***************
;p3_checkending: In 128k, check if we must see any special image, and show it if the answer is yes
;***************
p3_checkending:	;di
		ld	a,(aborted)		;Check if any track has been aborted
		and	a
		ret	nz			;No aborted track allowed
		ld	ix,car1			;First car
		ld	de,car2-car1
		ld	bc,4*256		;C=0, B=4 (number of cars)
p3_getwinner:	ld	a,(ix+SP_CONTOPT)
		cp	8
		jr	nz,p3_notcpuhard
		inc	c
p3_notcpuhard:	ld	a,(ix+SP_MAPPOINTS)	;position > 0 = winner
		and	a
		jr	nz,p3_getwinnerno1
		bit	7,(ix+SP_STATE)
		ret	z			;non-human winner = return
		ld	a,(ix+SP_POINTS)
		ld	(p3_points1+1),a	;get first place points
		jr	p3_getwinnerno2
p3_getwinnerno1: dec	a
		jr	nz,p3_getwinnerno2
		ld	a,(ix+SP_POINTS)
		ld	(p3_points2+1),a	;get second place points
p3_getwinnerno2: add	ix,de			;Point to next car
		djnz	p3_getwinner		;Loop for all cars
		dec	c
		ret	nz			;exit if number of CPU hard != 1
		ld	a,(mode)
		sub	1
		jr	c,p3_checkf1		;If mode was 0, check F1 conditions
		ret	nz
						;check GP2
		ld	a,(championship)
		cp	1
		jr	z,xend1			;If we've won, and championship was HARD, it's enough
		ret
p3_checkf1:	ld	a,(championship)
		and	a
		ret	z			;no glory for EASY championship
		cp	3
		ret	z			;no glory for PERSONAL championship either
		dec	a
		jr	z,p3_points1
						;check F1 hard
		ld	a,(p3_points1+1)
p3_points2:	sub	0
		cp	4
		jr	c,xend2			;If difference of points with the second is over 4, you may see the girl
		ret
p3_points1:	ld	a,0			;check F1 complete
		cp	72
		ret	nz			;Girl 3 (interlaced): only with 8*(6+3)=72 points

xend3:		ld	hl,girl31		;Move extra code for interlaced image, and compressed
		ld	de,mapa			; first half of that interlaced image to the "mapa" buffer, in page 2
		ld	bc,girl32-girl31	; (this is page 3, we need to get out of here before we switch to page 7
		ldir				; to do some screen swapping)

		call	mapa+girl31end-girl31	;Call girl31end routine in page 2
		ld	hl,girl32		;
		ld	de,16384
		call	deexo			;Uncompress second part of interlaced image at screen (page 5)
		ld	hl,(interrupt_redir+1)
		ld	(mapa+int_reredir+1-girl31),hl	;Keep previous interrupt routine
		ld	hl,mapa+int_girlswap-girl31
		ld	(interrupt_redir+1),hl	;Set new interrupt routine (executed in page 2)
		jr	xendcommon2
xend2:		ld	hl,girl2		;Select second screen
		jr	xendcommon
xend1:		ld	hl,girl1		;Select first screen
xendcommon:	ld	de,16384
		call	deexo			;Uncompres to screen
;		ei
xendcommon2:	ld	b,150			;3 seconds
pausababe:	halt
		djnz	pausababe		;do mandatory pause
xwait_key:	call	check_key
		jr	z,xwait_key		;Wait for key to exit
		ld	a,(setbank_high+1)
		and	247			;Set normal screen
		ld	(setbank_high+1),a
		ld	hl,(mapa+int_reredir+1-girl31)
		ld	hl,int_end
		ld	(interrupt_redir+1),hl	;Restore interrupt routine
		ei				;Restore interrupts
     		ret

girl1:		INCBIN	bindata\girl1.exp	;First compressed screen
girl2:		INCBIN	bindata\girl2.exp	;Second compressed screen
girl31:		INCBIN	bindata\girl31.exp	;Third compressed screen (interlaced, part 1)

girl31end:	ld	a,7			;This routine will be executed from page 2
		call	setbank			;Set page 7
;		di
		ld	de,49152		;Screen start address
		ld	hl,mapa
		call	deexo			;Uncompress to shadow screen in page 7
		ld	a,3
		call	setbank			;Restore page 3
;		di		
		ret
int_girlswap:	push	af
		ld	a,(setbank_high+1)	;System variable with previous value
		xor	8
		ld	(setbank_high+1),a
     		pop	af
int_reredir:	jp	int_end
girl32:		INCBIN	bindata\girl32.exp	;Third compressed screen (interlaced, part 2)
